﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0077_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

Try {
    $GenAILocalFoundationalModelSettings = Get-ItemPropertyValue 'HKLM:\Software\Policies\Google\Chrome' -Name GenAILocalFoundationalModelSettings
    if($GenAILocalFoundationalModelSettings -eq 1){
        Log-Message -message "GenAILocalFoundationalModelSettings configured value: $GenAILocalFoundationalModelSettings"
        Exit 0
    } else {
        Log-Message -message "GenAILocalFoundationalModelSettings configured incorrect value: $GenAILocalFoundationalModelSettings"
        Exit 1
    }
} Catch {
    Log-Message -message "The property does not exist or an error occurred: $_"
    Exit 1
}